package gov.va.med.mhv.sm.web.utils;

import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.smActions.AbstractInboxAction;

import javax.servlet.http.HttpSession;

public class LoginUtils {
	
	public static String getLastLogin(HttpSession httpSession){
		User user = (User) httpSession.getAttribute(AbstractInboxAction.CURRENT_USER);
		String lastLogin=null;
		if(user.getLastLogin()!=null){
			lastLogin = DateUtils.formatDate(user.getLastLogin(),DateUtils.ENGLISH_DAYOFWEEK_FORMAT);
		}
		return lastLogin;
	}
	
	public static String getLoggedUser(HttpSession httpSession){
		User user = (User)httpSession.getAttribute(AbstractInboxAction.CURRENT_USER);
		return user.getFirstName()+" "+user.getLastName();
	}
	
	public static boolean isClinician(HttpSession httpSession){
		User user = (User)httpSession.getAttribute(AbstractInboxAction.CURRENT_USER);
		if(user.getUserType().equals(UserTypeEnum.CLINICIAN))
			return true;
		else
			return false;
	}
	
}
